/*
 * Decompiled with CFR 0.152.
 */
package com.sync.delta;

import com.sync.delta.newLine;
import com.sync.delta.printFont;
import com.sync.delta.printString;
import com.sync.delta.printTab;
import com.sync.delta.printerObject;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PrintJob;
import java.util.Vector;

public class Printer
extends Canvas {
    Frame f;
    PrintJob pjob;
    Graphics pg;
    Vector objects;
    Point pt;
    Font fnt;
    Font tabFont;

    public Printer(Frame frm) {
        this.f = frm;
        this.f.add(this);
        this.setVisible(false);
        this.pjob = null;
        this.pt = new Point(0, 0);
        this.objects = new Vector();
        this.tabFont = new Font("MonoSpaced", 0, 12);
        this.fnt = new Font("SansSerif", 0, 12);
    }

    public void setFont(Font f) {
        this.objects.addElement(new printFont(f));
    }

    public void print(String s) {
        this.objects.addElement(new printString(s));
    }

    public void println(String s) {
        this.print(s);
        this.objects.addElement(new newLine());
    }

    public void newPage(Container c) {
        if (this.pjob == null) {
            this.pjob = this.getToolkit().getPrintJob(this.f, "Printer", null);
        }
        if (this.pjob != null) {
            this.pg = this.pjob.getGraphics();
            this.print(this.pg);
            this.pg.translate(0, this.pt.y);
            c.printComponents(this.pg);
            this.pg.dispose();
            this.pt = new Point(0, 0);
            this.objects = new Vector();
        } else {
            System.out.println("Print job canceled or an error has occured");
        }
    }

    public void newPageText() {
        if (this.pjob == null) {
            this.pjob = this.getToolkit().getPrintJob(this.f, "Printer", null);
        }
        if (this.pjob != null) {
            this.pg = this.pjob.getGraphics();
            this.print(this.pg);
            this.pg.translate(0, this.pt.y);
            this.pg.dispose();
            this.pt = new Point(0, 0);
            this.objects = new Vector();
        } else {
            System.out.println("Print job canceled or an error has occured");
        }
    }

    public void finalize() {
        this.endJob();
    }

    public void endJob() {
        if (this.pjob != null) {
            this.pjob.end();
        }
    }

    public void tab(int tabstop) {
        this.objects.addElement(new printTab(this.tabFont, tabstop));
    }

    public Dimension pageSize() {
        if (this.pjob == null) {
            return new Dimension(620, 790);
        }
        this.pjob = this.getToolkit().getPrintJob(this.f, "Printer", null);
        return this.pjob.getPageDimension();
    }

    public void paint(Graphics g) {
        this.pt = new Point(0, 0);
        this.print(g);
    }

    public void print(Graphics g) {
        ((Component)this.f).setFont(this.fnt);
        for (int i = 0; i < this.objects.size(); ++i) {
            printerObject p = (printerObject)this.objects.elementAt(i);
            p.draw(g, this.pt);
        }
    }
}

